---
id: papers
title: Papers using BoTorch
---

The main reference for BoTorch is

[BoTorch: A Framework for Efficient Monte-Carlo Bayesian Optimization](https://proceedings.neurips.cc/paper/2020/hash/f5b1b89d98b7286673128a5fb112cb9a-Abstract.html):

    @inproceedings{balandat2020botorch,
        title = {{BoTorch: A Framework for Efficient Monte-Carlo Bayesian Optimization}},
        author = {Balandat, Maximilian and Karrer, Brian and Jiang, Daniel R. and Daulton, Samuel and Letham, Benjamin and Wilson, Andrew Gordon and Bakshy, Eytan},
        booktitle = {Advances in Neural Information Processing Systems 33},
        year = 2020,
        url = {https://proceedings.neurips.cc/paper/2020/hash/f5b1b89d98b7286673128a5fb112cb9a-Abstract.html}
    }


Here is an incomplete selection of peer-reviewed Bayesian optimization papers that build off of BoTorch:

- [Sparse Bayesian Optimization](https://arxiv.org/pdf/2203.01900.pdf). Sulin Liu, Qing Feng, David Eriksson, Ben Letham, Eytan Bakshy. AISTATS 2023.

- [Bayesian Optimization over High-Dimensional Combinatorial Spaces via Dictionary-based Embeddings](https://arxiv.org/abs/2303.01774). Aryan Deshwal, Sebastian Ament, Maximilian Balandat, Eytan Bakshy, Janardhan Rao Doppa, David Eriksson. AISTATS 2023.

- [qEUBO: A Decision-Theoretic Acquisition Function for Preferential Bayesian Optimization](https://arxiv.org/pdf/2303.15746.pdf). Raul Astudillo, Zhiyuan Jerry Lin, Eytan Bakshy, Peter I. Frazier. AISTATS 2023.

- [Discovering Many Diverse Solutions with Bayesian Optimization](https://arxiv.org/pdf/2210.10953.pdf). Natalie Maus, Kaiwen Wu, David Eriksson, Jacob Gardner. AISTATS 2023.

- [Multi-Fidelity Bayesian Optimization with Unreliable Information Sources](https://arxiv.org/pdf/2210.13937.pdf). Petrus Mikkola, Julien Martinelli, Louis Filstroff, Samuel Kaski. AISTATS 2023.

- [Bayesian Optimization with Conformal Coverage Guarantees](https://arxiv.org/pdf/2210.12496.pdf). Samuel Stanton, Wesley Maddox, Andrew Gordon Wilson. AISTATS 2023.

- [Inducing Point Allocation for Sparse Gaussian Processes in High-Throughput Bayesian Optimisation](https://arxiv.org/pdf/2301.10123.pdf). Henry B. Moss, Sebastian W. Ober, Victor Picheny. AISTATS 2023.

- [Scalable Bayesian Optimization Using Vecchia Approximations of Gaussian Processes](https://arxiv.org/pdf/2203.01459.pdf). Felix Jimenez, Matthias Katzfuss. AISTATS 2023.

- [Active Bayesian Causal Inference](https://proceedings.neurips.cc/paper_files/paper/2022/hash/675e371eeeea99551ce47797ed6ed33e-Abstract-Conference.html). Christian Toth, Lars Lorch, Christian Knoll, Andreas Krause, Franz Pernkopf, Robert Peharz, Julius von Kügelgen. NeurIPS 2022.

- [Joint Entropy Search for Multi-objective Bayesian Optimization](https://arxiv.org/pdf/2210.02905.pdf). Ben Tu, Axel Gandy, Nikolas Kantas, Behrang Shafei. NeurIPS 2022.

- [Local Bayesian Optimization via Maximizing Probability of Descent](https://arxiv.org/pdf/2210.11662.pdf). Quan Nguyen, Kaiwen Wu, Jacob R. Gardner, Roman Garnett. NeurIPS 2022.

- [Local Latent Space Bayesian Optimization over Structured Inputs](https://proceedings.neurips.cc/paper_files/paper/2022/hash/ded98d28f82342a39f371c013dfb3058-Abstract-Conference.html). Natalie Maus, Haydn Jones, Juston Moore, Matt J. Kusner, John Bradshaw, Jacob Gardner. NeurIPS 2022.

- [SnAKe: Bayesian Optimization via Pathwise Exploration](https://proceedings.neurips.cc/paper_files/paper/2022/hash/e4bab1843c8d5a69f5abfd0824593493-Abstract-Conference.html). Jose Pablo Folch, Shiqiang Zhang, Robert Lee, Behrang Shafei, David Walz, Calvin Tsay, Mark van der Wilk, Ruth Misener. NeurIPS 2022.

- [Bayesian Optimization over Discrete and Mixed Spaces via Probabilistic Reparameterization](https://arxiv.org/pdf/2210.10199.pdf). Samuel Daulton, Xingchen Wan, David Eriksson, Maximilian Balandat, Michael A Osborne, Eytan Bakshy. NeurIPS 2022.

- [Rethinking Optimization with Differentiable Simulation from a Global Perspective](https://proceedings.mlr.press/v205/antonova23a.html). Rika Antonova, Jingyun Yang, Krishna Murthy Jatavallabhula, Jeannette Bohg. CoRL 2022.

- [Robust Multi-Objective Bayesian Optimization Under Input Noise](https://arxiv.org/pdf/2202.07549.pdf). Samuel Daulton, Sait Cakmak, Maximilian Balandat, Michael A. Osborne, Enlu Zhou, Eytan Bakshy. ICML 2022.

- [Accelerating Bayesian Optimization for Biological Sequence Design with Denoising Autoencoders
](https://proceedings.mlr.press/v162/stanton22a.html). Samuel Stanton, Wesley Maddox, Nate Gruver, Phillip Maffettone, Emily Delaney, Peyton Greenside, Andrew Gordon Wilson. ICML 2022.

- [Multi-Objective Bayesian Optimization over High-Dimensional Search Spaces](https://arxiv.org/pdf/2109.10964.pdf).
Samuel Daulton, David Eriksson, Maximilian Balandat, Eytan Bakshy. UAI 2022.

- [Preference Exploration for Efficient Bayesian Optimization with Multiple Outcomes](https://arxiv.org/pdf/2203.11382.pdf).
Jerry Lin, Raul Astudillo, Peter Frazier, Eytan Bakshy. AISTATS 2022.

- [Look-Ahead Acquisition Functions for Bernoulli Level Set Estimation](https://arxiv.org/pdf/2203.09751.pdf).
Benjamin Letham, Eytan Bakshy, Michael Shvartsman. AISTATS 2022.

- [GIBBON: General-purpose Information-Based Bayesian OptimisatioN](https://jmlr.org/papers/volume22/21-0120/21-0120.pdf). Henry B. Moss, David S. Leslie, Javier Gonzalez, Paul Rayson. JMLR 2021.

- [Bayesian Optimization of Function Networks
](https://proceedings.neurips.cc/paper/2021/hash/792c7b5aae4a79e78aaeda80516ae2ac-Abstract.html). Raul Astudillo, Peter Frazier. NeurIPS 2021.

- [Conditioning Sparse Variational Gaussian Processes
for Online Decision-making](https://proceedings.neurips.cc/paper/2021/file/325eaeac5bef34937cfdc1bd73034d17-Paper.pdf). Wesley J. Maddox, Samuel Stanton, and Andrew G. Wilson. NeurIPS 2021.

- [Multi-Step Budgeted Bayesian Optimization with Unknown Evaluation Costs](https://arxiv.org/pdf/2111.06537.pdf).
Raul Astudillo, Daniel Jiang, Maximilian Balandat, Eytan Bakshy, Peter Frazier. NeurIPS 2021.

- [Parallel Bayesian Optimization of Multiple Noisy Objectives with Expected Hypervolume Improvement](https://arxiv.org/pdf/2105.08195.pdf).
Samuel Daulton, Max Balandat, Eytan Bakshy. NeurIPS 2021.

- [Bayesian Optimization with High-Dimensional Outputs](https://papers.nips.cc/paper/2021/hash/a0d3973ad100ad83a64c304bb58677dd-Abstract.html). Wesley J. Maddox, Maximilian Balandat, Andrew G. Wilson, Eytan Bakshy. NeurIPS 2021.

- [Combining Latent Space and Structured Kernels for Bayesian Optimization over Combinatorial Spaces](https://papers.nips.cc/paper/2021/hash/44e76e99b5e194377e955b13fb12f630-Abstract.html). Aryan Deshwal, Jana Doppa. NeurIPS 2021.

- [Improving Black-box Optimization in VAE Latent Space Using Decoder Uncertainty](https://papers.nips.cc/paper/2021/hash/06fe1c234519f6812fc4c1baae25d6af-Abstract.html). Pascal Notin, José Miguel Hernández-Lobato, Yarin Gal. NeurIPS 2021.

- [Local Policy Search with Bayesian Optimization](https://papers.nips.cc/paper_files/paper/2021/hash/ad0f7a25211abc3889cb0f420c85e671-Abstract.html). Sarah Müller, Alexander von Rohr, Sebastian Trimpe. NeurIPS 2021.

- [Risk-averse Heteroscedastic Bayesian Optimization](https://papers.nips.cc/paper/2021/hash/8f97d1d7e02158a83ceb2c14ff5372cd-Abstract.html). Anastasia Makarova, Ilnura Usmanova, Ilija Bogunovic, Andreas Krause. NeurIPS 2021.

- [High-Dimensional Bayesian Optimization with Sparse Axis-Aligned Subspaces](https://proceedings.mlr.press/v161/eriksson21a.html). David Eriksson, Martin Jankowiak. UAI 2021.

- [Bayesian Optimization over Permutation Spaces](https://arxiv.org/abs/2112.01049). Aryan Deshwal, Syrine Belakaria, Janardhan Rao Doppa, Dae Hyun Kim. AAAI 2021.

- [Bayesian Optimization of Risk Measures](https://proceedings.neurips.cc/paper/2020/hash/e8f2779682fd11fa2067beffc27a9192-Abstract.html). Sait Cakmak, Raul Astudillo Marban, Peter Frazier, Enlu Zhou. NeurIPS 2020.

- [Differentiable Expected Hypervolume Improvement for Parallel Multi-Objective Bayesian Optimization](https://proceedings.neurips.cc/paper/2020/hash/6fec24eac8f18ed793f5eaad3dd7977c-Abstract.html). Sam Daulton, Maximilian Balandat, Eytan Bakshy. NeurIPS 2020.

- [Efficient Nonmyopic Bayesian Optimization via One-Shot Multi-Step Trees](https://proceedings.neurips.cc/paper/2020/hash/d1d5923fc822531bbfd9d87d4760914b-Abstract.html). Shali Jiang, Daniel Jiang, Maximilian Balandat, Brian Karrer, Jacob Gardner, Roman Garnett. NeurIPS 2020.

- [High-Dimensional Bayesian Optimization via Nested Riemannian Manifolds](https://proceedings.neurips.cc/paper/2020/hash/f05da679342107f92111ad9d65959cd3-Abstract.html). Noémie Jaquier, Leonel Rozo. NeurIPS 2020.

- [High-Dimensional Contextual Policy Search with Unknown Context Rewards using Bayesian Optimization](https://proceedings.neurips.cc/paper/2020/hash/faff959d885ec0ecf70741a846c34d1d-Abstract.html). Qing Feng, Benjamin Letham, Hongzi Mao, Eytan Bakshy. NeurIPS 2020.

- [Re-Examining Linear Embeddings for High-Dimensional Bayesian Optimization](https://proceedings.neurips.cc/paper/2020/hash/10fb6cfa4c990d2bad5ddef4f70e8ba2-Abstract.html). Ben Letham, Roberto Calandra, Akshara Rai, Eytan Bakshy. NeurIPS 2020.

- [PareCO: Pareto-aware Channel Optimization for Slimmable Neural Networks
](https://arxiv.org/abs/2007.11752). Ting-Wu Chin, Ari S. Morcos, Diana Marculescu. ICML 2020 Workshop on Real World Experiment Design and Active Learning.

*Please feel free to add any other peer reviewed works that build off of botorch via a PR!*
